/* ***************************************************************************************
* FILE:          SimTouch.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimTouch.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_SIMTOUCH_H
#define HMIBASE_TRACE_COMMAND_SIMTOUCH_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

struct SimTouchPayload
{
   unsigned short xPos;
   unsigned short yPos;
   ::bosch::cm::ai::hmi::appctrl::trace::Commands::simulatedTouchStates state;

   SimTouchPayload(unsigned short x, unsigned short y, ::bosch::cm::ai::hmi::appctrl::trace::Commands::simulatedTouchStates s) : xPos(x), yPos(y), state(s)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const SimTouchPayload& payload)
   {
      os << payload.xPos;
      os << payload.yPos;
      os << payload.state;
      return os;
   }
};


class SimTouch :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< SimTouchPayload >
{
   private:

      SimTouch();

   public:
      virtual ~SimTouch();

      static SimTouch& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SimTouchPayload > >& payload);

      static void TraceCommand(unsigned short xPos, unsigned short yPos, ::bosch::cm::ai::hmi::appctrl::trace::Commands::simulatedTouchStates state = ::bosch::cm::ai::hmi::appctrl::trace::Commands::simulatedTouchStates__COMPACT);
};


}
}


}
#endif
