/* ***************************************************************************************
* FILE:          SimSetFocus.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimSetFocus.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_SIMSETFOCUS_H
#define HMIBASE_TRACE_COMMAND_SIMSETFOCUS_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

enum enFocusAction
{
   enFocusHide,
   enFocusShow,
   enFocusSet
};


enum enFocusTimerAction
{
   enFocusTimerNoAction,
   enFocusTimerRestart,
   enFocusTimerStop
};


struct SimSetFocusPayload
{
   std::string appName;
   enFocusAction action;
   enFocusTimerAction timerAction;
   std::string viewName;
   std::string widgetName;

   SimSetFocusPayload(const char* a, enFocusAction act, enFocusTimerAction timerAct, const char* vn, const char* wn) : appName(a), action(act), timerAction(timerAct), viewName(vn), widgetName(wn)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const SimSetFocusPayload& payload)
   {
      os << payload.appName;
      os << payload.action;
      os << payload.timerAction;
      os << payload.viewName;
      os << payload.widgetName;
      return os;
   }
};


class SimSetFocus :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< SimSetFocusPayload >
{
   private:

      SimSetFocus();

   public:
      virtual ~SimSetFocus();

      static SimSetFocus& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SimSetFocusPayload > >& payload);

      static void TraceCommand(const char* appName, enFocusAction eAction, enFocusTimerAction eTimerAction, const char* viewName, const char* widgetName);
};


}
}


}
#endif
