/* ***************************************************************************************
* FILE:          SimSetFocus.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimSetFocus.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SimSetFocus.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace::command;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::SimSetFocus::
#include "trcGenProj/Header/SimSetFocus.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

SimSetFocus& SimSetFocus::GetInstance()
{
   static SimSetFocus theInstance;
   return theInstance;
}


SimSetFocus::SimSetFocus()
{
   ETG_I_REGISTER_FILE();
}


SimSetFocus::~SimSetFocus()
{
   ETG_I_UNREGISTER_FILE();
}


void SimSetFocus::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SimSetFocusPayload > >& payload)
{
   if (_stub)
   {
      std::vector<int> pids;
      if (_stub->getClientsPid(payload->get0().appName, pids))
      {
         for (std::vector<int>::iterator it = pids.begin(); it != pids.end(); ++it)
         {
            _stub->sendSimFocusReqSignal(SimFocusReqData(*it, (unsigned int)(payload->get0().action), (unsigned int)(payload->get0().timerAction), payload->get0().viewName, payload->get0().widgetName));
         }
      }
      else
      {
         ETG_TRACE_FATAL(("SimSetFocus Unknown application '%s'", payload->get0().appName));
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "SimSetFocus %50s %d %d %50s %50s", ETG_I_STRING, ETG_I_CENUM(enFocusAction), ETG_I_CENUM(enFocusTimerAction), ETG_I_STRING, ETG_I_STRING))
void SimSetFocus::TraceCommand(const char* appName, enFocusAction action, enFocusTimerAction timerAction, const char* viewName, const char* widgetName)
{
   if (GetInstance()._stub)
   {
      SimSetFocusPayload payload(appName, action, timerAction, viewName, widgetName);
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
