/* ***************************************************************************************
* FILE:          SimRotateEncoder.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimRotateEncoder.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_SIMROTATEENCODER_H
#define HMIBASE_TRACE_COMMAND_SIMROTATEENCODER_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

struct SimRotateEncoderPayload
{
   std::string appName;
   std::string encCode;
   int encSteps;
   unsigned int userData;

   SimRotateEncoderPayload(const char* a, const char* c, int s, unsigned int u) : appName(a), encCode(c), encSteps(s), userData(u)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const SimRotateEncoderPayload& payload)
   {
      os << payload.appName;
      os << payload.encCode;
      os << payload.encSteps;
      os << payload.userData;
      return os;
   }
};


class SimRotateEncoder :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< SimRotateEncoderPayload >
{
   private:

      SimRotateEncoder();

   public:
      virtual ~SimRotateEncoder();

      static SimRotateEncoder& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SimRotateEncoderPayload > >& payload);

      static void TraceCommand(const char* appName, const char* encCode, int encSteps, unsigned int userData);
};


}
}


}
#endif
