/* ***************************************************************************************
* FILE:          SimRotateEncoder.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimRotateEncoder.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SimRotateEncoder.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::SimRotateEncoder::
#include "trcGenProj/Header/SimRotateEncoder.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

SimRotateEncoder& SimRotateEncoder::GetInstance()
{
   static SimRotateEncoder theInstance;
   return theInstance;
}


SimRotateEncoder::SimRotateEncoder()
{
   ETG_I_REGISTER_FILE();
}


SimRotateEncoder::~SimRotateEncoder()
{
   ETG_I_UNREGISTER_FILE();
}


void SimRotateEncoder::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SimRotateEncoderPayload > >& payload)
{
   if (_stub)
   {
      std::vector<int> pids;
      if (_stub->getClientsPid(payload->get0().appName, pids))
      {
         for (std::vector<int>::iterator it = pids.begin(); it != pids.end(); ++it)
         {
            _stub->sendSimRotateEncoderSignal(SimRotateEncoderData(*it, payload->get0().encCode, payload->get0().encSteps, payload->get0().userData));
         }
      }
      else
      {
         ETG_TRACE_FATAL(("SimRotateEncoder Unknown application '%s'", payload->get0().appName));
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "SimRotateEncoder %50s %50s %d %u ", ETG_I_STRING, ETG_I_STRING, int, unsigned int))
void SimRotateEncoder::TraceCommand(const char* appName, const char* encCode, int encSteps, unsigned int userData)
{
   if (GetInstance()._stub)
   {
      SimRotateEncoderPayload payload(appName, encCode, encSteps, userData);
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
