/* ***************************************************************************************
* FILE:          SimJoystick.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimJoystick.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_SIMJOYSTICK_H
#define HMIBASE_TRACE_COMMAND_SIMJOYSTICK_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

enum enFocusDirection
{
   Up = 0,
   Down = 1,
   Left = 2,
   Right = 3,
   UpperLeft = 4,
   UpperRight = 5,
   LowerLeft = 6,
   LowerRight = 7
};


struct SimJoystickPayload
{
   std::string appName;
   enFocusDirection direction;
   std::string source;

   SimJoystickPayload(const char* a, enFocusDirection d, const char* src) : appName(a), direction(d), source(src)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const SimJoystickPayload& payload)
   {
      os << payload.appName;
      os << payload.direction;
      os << payload.source;
      return os;
   }
};


class SimJoystick :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< SimJoystickPayload >
{
   private:

      SimJoystick();

   public:
      virtual ~SimJoystick();

      static SimJoystick& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SimJoystickPayload > >& payload);

      static void TraceCommand(const char* appName, enFocusDirection direction, const char* source);
};


}
}


}
#endif
