/* ***************************************************************************************
* FILE:          SimEnterKey.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimEnterKey.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_SIMENTERKEY_H
#define HMIBASE_TRACE_COMMAND_SIMENTERKEY_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

enum enHardKeyState
{
   HARDKEYSTATE_UNKNOWN = 0,
   HARDKEYSTATE_DOWN,
   HARDKEYSTATE_UP,
   HARDKEYSTATE_LONG1,
   HARDKEYSTATE_LONG2,
   HARDKEYSTATE_LONG3,
   HARDKEYSTATE_LONG4,
   HARDKEYSTATE_LONG5,
   HARDKEYSTATE_LONG6,
   HARDKEYSTATE_LONG7,
   HARDKEYSTATE_LONG8,
   HARDKEYSTATE_LONG9,
   HARDKEYSTATE_LONG10,
   HARDKEYSTATE_ABORT,
   HARDKEYSTATE_LONGUP,
   HARDKEYSTATE_REPEAT
};


struct SimEnterKeyPayload
{
   std::string appName;
   enHardKeyState state;
   std::string source;

   SimEnterKeyPayload(const char* a, enHardKeyState s, const char* src) : appName(a), state(s), source(src)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const SimEnterKeyPayload& payload)
   {
      os << payload.appName;
      os << payload.state;
      os << payload.source;
      return os;
   }
};


class SimEnterKey :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< SimEnterKeyPayload >
{
   private:

      SimEnterKey();

   public:
      virtual ~SimEnterKey();

      static SimEnterKey& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SimEnterKeyPayload > >& payload);

      static void TraceCommand(const char* appName, enHardKeyState state, const char* source);
};


}
}


}
#endif
