/* ***************************************************************************************
* FILE:          SetWidgetProperty.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SetWidgetProperty.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SetWidgetProperty.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::SetWidgetProperty::
#include "trcGenProj/Header/SetWidgetProperty.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

SetWidgetProperty& SetWidgetProperty::GetInstance()
{
   static SetWidgetProperty theInstance;
   return theInstance;
}


SetWidgetProperty::SetWidgetProperty()
{
   ETG_I_REGISTER_FILE();
}


SetWidgetProperty::~SetWidgetProperty()
{
   ETG_I_UNREGISTER_FILE();
}


void SetWidgetProperty::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SetWidgetPropertyPayload > >& payload)
{
   if (_stub)
   {
      std::vector <std::string> widgetNamesInput;
      if (payload->get0().parent.empty() == false)
      {
         widgetNamesInput.push_back(payload->get0().parent);
         widgetNamesInput.push_back("#");
      }
      widgetNamesInput.push_back(payload->get0().widget);

      _stub->sendWidgetPropertyValueSetterSignal(WidgetPropertyValueSetterData(0, widgetNamesInput, payload->get0().property, payload->get0().propertyValue));
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "Set_WidgetProperty %50s %50s %50s %50s", ETG_I_STRING, ETG_I_STRING, ETG_I_STRING, ETG_I_STRING))
void SetWidgetProperty::TraceCommand(const char* parentWidgetName, const char* childWidgetName, const char* propertyName, const char* propertyValue)
{
   SetWidgetPropertyPayload payload(childWidgetName, parentWidgetName, propertyName, propertyValue);
   GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
}


ETG_I_CMD_DEFINE((TraceCommand, "Set_WidgetProperty %50s %50s %50s", ETG_I_STRING, ETG_I_STRING, ETG_I_STRING))
void SetWidgetProperty::TraceCommand(const char* widgetName, const char* propertyName, const char* propertyValue)
{
   SetWidgetPropertyPayload payload(widgetName, propertyName, propertyValue);
   GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
}


}
}


}
