/* ***************************************************************************************
* FILE:          SetLocale.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SetLocale.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SetLocale.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::SetLocale::
#include "trcGenProj/Header/SetLocale.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

SetLocale& SetLocale::GetInstance()
{
   static SetLocale theInstance;
   return theInstance;
}


SetLocale::SetLocale()
{
   ETG_I_REGISTER_FILE();
}


SetLocale::~SetLocale()
{
   ETG_I_UNREGISTER_FILE();
}


void SetLocale::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SetLocalePayload > >& payload)
{
   if (_stub)
   {
      std::vector<std::string > param;
      param.push_back(payload->get0());
      _stub->sendTraceQuerySignal(TraceQueryData(0, traceQueryId__SET_LOCALE, param));
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "Set_Locale %s", ETG_I_STRING))
void SetLocale::TraceCommand(const char* locale)
{
   if (GetInstance()._stub)
   {
      SetLocalePayload payload = locale;
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
