/* ***************************************************************************************
* FILE:          SetFrameRate.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SetFrameRate.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_SETFRAMERATE_H
#define HMIBASE_TRACE_COMMAND_SETFRAMERATE_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

struct SetFrameRatePayload
{
   std::string appName;
   unsigned int fps;

   SetFrameRatePayload(const char* a, unsigned int f) : appName(a), fps(f)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const SetFrameRatePayload& payload)
   {
      os << payload.appName;
      os << payload.fps;
      return os;
   }
};


class SetFrameRate :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< SetFrameRatePayload >
{
   private:

      SetFrameRate();

   public:
      virtual ~SetFrameRate();

      static SetFrameRate& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SetFrameRatePayload > >& payload);

      static void TraceCommand(const char* appName,  unsigned int fps = 0);
};


}
}


}
#endif
