/* ***************************************************************************************
* FILE:          SetFrameRate.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SetFrameRate.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SetFrameRate.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::SetFrameRate::
#include "trcGenProj/Header/SetFrameRate.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

SetFrameRate& SetFrameRate::GetInstance()
{
   static SetFrameRate theInstance;
   return theInstance;
}


SetFrameRate::SetFrameRate()
{
   ETG_I_REGISTER_FILE();
}


SetFrameRate::~SetFrameRate()
{
   ETG_I_UNREGISTER_FILE();
}


void SetFrameRate::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SetFrameRatePayload > >& payload)
{
   if (_stub)
   {
      std::vector<int> pids;
      std::stringstream str;
      std::vector<std::string> param;
      str << payload->get0().fps;
      param.push_back(str.str());

      if (_stub->getClientsPid(payload->get0().appName, pids))
      {
        for (std::vector<int>::iterator it = pids.begin(); it != pids.end(); ++it)
        {
            _stub->sendTraceQuerySignal(TraceQueryData(*it, traceQueryId__SET_FRAME_RATE, param));
            ETG_TRACE_FATAL(("sendTraceQuerySignal to '%s'", payload->get0().appName.c_str()));
        }
      }
      else
      {
         ETG_TRACE_FATAL(("Unknown application '%s'", payload->get0().appName));
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "SetFrameRate %20s %u", ETG_I_STRING, unsigned int))
void SetFrameRate::TraceCommand(const char* appName, const unsigned int fps)
{
   if (GetInstance()._stub)
   {
      SetFrameRatePayload payload(appName, fps);
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
