/* ***************************************************************************************
* FILE:          SetCgiTraceLevel.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SetCgiTraceLevel.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SetCgiTraceLevel.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::SetCgiTraceLevel::
#include "trcGenProj/Header/SetCgiTraceLevel.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

SetCgiTraceLevel& SetCgiTraceLevel::GetInstance()
{
   static SetCgiTraceLevel theInstance;
   return theInstance;
}


SetCgiTraceLevel::SetCgiTraceLevel()
{
   ETG_I_REGISTER_FILE();
}


SetCgiTraceLevel::~SetCgiTraceLevel()
{
   ETG_I_UNREGISTER_FILE();
}


void SetCgiTraceLevel::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SetCgiTraceLevelPayload > >& payload)
{
   if (_stub)
   {
      std::vector<std::string > param;
      std::stringstream ss;
      ss << payload->get0();
      param.push_back(ss.str());
      _stub->sendTraceQuerySignal(TraceQueryData(0, traceQueryId__SET_CGITRACELEVEL, param));
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "Set_CgiTraceLevel %d", ETG_I_CENUM(command::enTraceLevel)))
void SetCgiTraceLevel::TraceCommand(::hmibase::trace::command::enTraceLevel level)
{
   if (GetInstance()._stub)
   {
      SetCgiTraceLevelPayload payload = level;
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
