/* ***************************************************************************************
* FILE:          GetWidgetPropertyInfo.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetWidgetPropertyInfo.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "GetWidgetPropertyInfo.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::GetWidgetPropertyInfo::
#include "trcGenProj/Header/GetWidgetPropertyInfo.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

GetWidgetPropertyInfo& GetWidgetPropertyInfo::GetInstance()
{
   static GetWidgetPropertyInfo theInstance;
   return theInstance;
}


GetWidgetPropertyInfo::GetWidgetPropertyInfo()
{
   ETG_I_REGISTER_FILE();
}


GetWidgetPropertyInfo::~GetWidgetPropertyInfo()
{
   ETG_I_UNREGISTER_FILE();
}


void GetWidgetPropertyInfo::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< GetWidgetPropertyInfoPayload > >& payload)
{
   if (_stub)
   {
      std::vector <std::string> data;
      data.push_back(payload->get0().property);
      if (payload->get0().parent.empty() == false)
      {
         data.push_back(payload->get0().parent);
         data.push_back("#");
      }
      data.push_back(payload->get0().widget);

      _stub->sendTraceQuerySignal(TraceQueryData(0, traceQueryId__GET_WIDGET_PROPERTY_INFO, data));
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "Get_WidgetPropertyInfo %100s %100s", ETG_I_STRING, ETG_I_STRING))
void GetWidgetPropertyInfo::TraceCommand(const char* widgetName, const char* propertyName)
{
   GetWidgetPropertyInfoPayload payload(widgetName, propertyName);
   GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
}


ETG_I_CMD_DEFINE((TraceCommand, "Get_WidgetPropertyInfo %50s %50s %50s", ETG_I_STRING, ETG_I_STRING, ETG_I_STRING))
void GetWidgetPropertyInfo::TraceCommand(const char* parentWidgetName, const char* widgetName, const char* propertyName)
{
   GetWidgetPropertyInfoPayload payload(widgetName, propertyName, parentWidgetName);
   GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
}


}
}


}
