/* ***************************************************************************************
* FILE:          GetWidgetInstanceInfo.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetWidgetInstanceInfo.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "GetWidgetInstanceInfo.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::GetWidgetInstanceInfo::
#include "trcGenProj/Header/GetWidgetInstanceInfo.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

GetWidgetInstanceInfo& GetWidgetInstanceInfo::GetInstance()
{
   static GetWidgetInstanceInfo theInstance;
   return theInstance;
}


GetWidgetInstanceInfo::GetWidgetInstanceInfo()
{
   ETG_I_REGISTER_FILE();
}


GetWidgetInstanceInfo::~GetWidgetInstanceInfo()
{
   ETG_I_UNREGISTER_FILE();
}


void GetWidgetInstanceInfo::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< GetWidgetInstanceInfoPayload > >& payload)
{
   if (_stub)
   {
      std::vector <std::string> widgetNameData;
      if (payload->get0().parent.empty() == false)
      {
         widgetNameData.push_back(payload->get0().parent);
         widgetNameData.push_back("#");
      }
      widgetNameData.push_back(payload->get0().widget);
      _stub->sendTraceQuerySignal(TraceQueryData(0, traceQueryId__GET_WIDGET_INSTANCE_INFO, widgetNameData));
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "Get_WidgetInstanceInfo %s", ETG_I_STRING))
void GetWidgetInstanceInfo::TraceCommand(const char* widgetName)
{
   if (GetInstance()._stub)
   {
      GetWidgetInstanceInfoPayload payload(widgetName);
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "Get_WidgetInstanceInfo %100s %100s", ETG_I_STRING, ETG_I_STRING))
void GetWidgetInstanceInfo::TraceCommand(const char* parentWidgetName, const char* childWidgetName)
{
   GetWidgetInstanceInfoPayload payload(childWidgetName, parentWidgetName);
   GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
}


}
}


}
