/* ***************************************************************************************
* FILE:          GetTopActiveSurfaceNonPermanent.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetTopActiveSurfaceNonPermanent.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "GetTopActiveSurfaceNonPermanent.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::GetTopActiveSurfaceNonPermanent::
#include "trcGenProj/Header/GetTopActiveSurfaceNonPermanent.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

GetTopActiveSurfaceNonPermanent& GetTopActiveSurfaceNonPermanent::GetInstance()
{
   static GetTopActiveSurfaceNonPermanent theInstance;
   return theInstance;
}


GetTopActiveSurfaceNonPermanent::GetTopActiveSurfaceNonPermanent()
{
   ETG_I_REGISTER_FILE();
}


GetTopActiveSurfaceNonPermanent::~GetTopActiveSurfaceNonPermanent()
{
   ETG_I_UNREGISTER_FILE();
}


void GetTopActiveSurfaceNonPermanent::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple0 >& /*payload*/)
{
   if (_stub)
   {
      std::vector<int> pids;
      if (_stub->getClientsPid("", pids))
      {
         if (pids.size() > 0)
         {
            _stub->sendTraceQuerySignal(TraceQueryData(pids[0], traceQueryId__GET_TOP_ACTIVE_SURFACE_NON_PERMANENT, std::vector< ::std::string >()));
         }
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "Get_Top_Active_Surface_Non_Permanent"))
void GetTopActiveSurfaceNonPermanent::TraceCommand()
{
   if (GetInstance()._stub)
   {
      GetInstance()._stub->sendLocalMessage(GetInstance());
   }
}


}
}


}
