/* ***************************************************************************************
* FILE:          GetSMInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetSMInfo.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_GETSMINFO_H
#define HMIBASE_TRACE_COMMAND_GETSMINFO_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/TraceQueryResponseHandler.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {

class HMIBaseTraceCmds;

namespace command {

typedef std::string GetSMInfoPayload;

class GetSMInfo :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< GetSMInfoPayload >,
   public ::hmibase::trace::TraceQueryResponseHandler
{
   private:

      GetSMInfo();

   public:
      virtual ~GetSMInfo();

      static GetSMInfo& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< GetSMInfoPayload > >& payload);

      virtual void Configure(HMIBaseTraceCmds* baseComponent);

      virtual bool Handle(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateTraceQueryResultRequest >& data);

      static void TraceCommand();
      static void TraceCommand(const char* appName);
};


}
}


}
#endif
