/* ***************************************************************************************
* FILE:          GetPossibleTouchPointForElemWithName.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetPossibleTouchPointForElemWithName.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_GETPOSSIBLETOUCHPOINTFORELEMWITHNAME_H
#define HMIBASE_TRACE_COMMAND_GETPOSSIBLETOUCHPOINTFORELEMWITHNAME_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

struct GetPossibleTouchPointForElemWithNamePayload
{
   std::string viewName;
   std::string widgetName;
   std::string parentWidgetName;

   GetPossibleTouchPointForElemWithNamePayload(const char* vn, const char* wn, const char* pwn = 0) : viewName(vn), widgetName(wn)
   {
      if (pwn != 0)
      {
         parentWidgetName = pwn;
      }
   }

   friend std::ostream& operator<<(std::ostream& os, const GetPossibleTouchPointForElemWithNamePayload& payload)
   {
      os << payload.viewName;
      os << payload.widgetName;
      os << payload.parentWidgetName;
      return os;
   }
};


class GetPossibleTouchPointForElemWithName :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< GetPossibleTouchPointForElemWithNamePayload >
{
   private:

      GetPossibleTouchPointForElemWithName();

   public:
      virtual ~GetPossibleTouchPointForElemWithName();

      static GetPossibleTouchPointForElemWithName& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< GetPossibleTouchPointForElemWithNamePayload > >& payload);

      static void TraceCommand(const char* viewName, const char* widgetName);
      static void TraceCommand(const char* viewName, const char* parentWidgetName, const char* widgetName);
};


}
}


}
#endif
