/* ***************************************************************************************
* FILE:          GetPossibleTouchPointForElemWithName.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetPossibleTouchPointForElemWithName.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "GetPossibleTouchPointForElemWithName.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::GetPossibleTouchPointForElemWithName::
#include "trcGenProj/Header/GetPossibleTouchPointForElemWithName.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

GetPossibleTouchPointForElemWithName& GetPossibleTouchPointForElemWithName::GetInstance()
{
   static GetPossibleTouchPointForElemWithName theInstance;
   return theInstance;
}


GetPossibleTouchPointForElemWithName::GetPossibleTouchPointForElemWithName()
{
   ETG_I_REGISTER_FILE();
}


GetPossibleTouchPointForElemWithName::~GetPossibleTouchPointForElemWithName()
{
   ETG_I_UNREGISTER_FILE();
}


void GetPossibleTouchPointForElemWithName::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< GetPossibleTouchPointForElemWithNamePayload > >& payload)
{
   if (_stub)
   {
      std::vector<std::string > param;
      param.push_back(payload->get0().viewName);

      if (payload->get0().parentWidgetName.empty() == false)
      {
         param.push_back(payload->get0().parentWidgetName);
         param.push_back("#");
      }
      param.push_back(payload->get0().widgetName);
      _stub->sendTraceQuerySignal(TraceQueryData(0, traceQueryId__GET_POSSIBLE_TOUCHPOINT_ELEM_NAME, param));
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "Get_PossibleTouchPointForElemWithName %100s %100s", ETG_I_STRING, ETG_I_STRING))
ETG_I_CMD_DEFINE((TraceCommand, "Get_PossibleTouchPointForElemWithName %100s %50s %50s", ETG_I_STRING, ETG_I_STRING, ETG_I_STRING))
void GetPossibleTouchPointForElemWithName::TraceCommand(const char* viewName, const char* widgetName)
{
   if (GetInstance()._stub)
   {
      GetPossibleTouchPointForElemWithNamePayload payload(viewName, widgetName);
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


void GetPossibleTouchPointForElemWithName::TraceCommand(const char* viewName, const char* parentWidgetName, const char* widgetName)
{
   if (GetInstance()._stub)
   {
      GetPossibleTouchPointForElemWithNamePayload payload(viewName, widgetName, parentWidgetName);
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
