/* ***************************************************************************************
* FILE:          GetAllLoadedScenes.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetAllLoadedScenes.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "GetAllLoadedScenes.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace::command;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::GetAllLoadedScenes::
#include "trcGenProj/Header/GetAllLoadedScenes.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

GetAllLoadedScenes& GetAllLoadedScenes::GetInstance()
{
   static GetAllLoadedScenes theInstance;
   return theInstance;
}


GetAllLoadedScenes::GetAllLoadedScenes() : _currentRequest(LOADED)
{
   ETG_I_REGISTER_FILE();
}


GetAllLoadedScenes::~GetAllLoadedScenes()
{
   ETG_I_UNREGISTER_FILE();
}


void GetAllLoadedScenes::Configure(HMIBaseTraceCmds* baseComponent)
{
   TraceCmdHandler::Configure(baseComponent);

   if (_stub)
   {
      _stub->RegisterMethodHandler(this);
   }
}


void GetAllLoadedScenes::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< GetAllViewsPayload > >& payload)
{
   if (_stub)
   {
      std::vector<std::string > param;
      std::stringstream ss;
      ss << payload->get0();
      param.push_back(ss.str());

      _stub->sendTraceQuerySignal(TraceQueryData(0, traceQueryId__GET_ALL_LOADEDSCENES, param));
   }
}


bool GetAllLoadedScenes::Handle(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateTraceQueryResultRequest >& data)
{
   traceQueryId queryId = data->getData().getQueryId();
   std::string s;
   _stub->GetClientNameFromPid(data->getData().getPid(), s);
   if (queryId == traceQueryId__GET_ALL_LOADEDSCENES)
   {
      ETG_TRACE_FATAL(("LOADED SCENES START for [%s]", s.c_str()));
      std::vector<std::string> loadedscenes = data->getData().getQueryInput();
      for (std::vector<std::string>::iterator it = loadedscenes.begin(); it != loadedscenes.end(); ++it)
      {
         ETG_TRACE_FATAL(("%s", it->c_str()));
      }
      ETG_TRACE_FATAL(("LOADED SCENES END"));
   }
   else if (queryId == traceQueryId__GET_ALL_ACTIVE_RENDERED_SCENES)
   {
      std::vector<std::string> activeRenderedScenes = data->getData().getQueryInput();
      if (activeRenderedScenes.size() > 0)
      {
         ETG_TRACE_FATAL(("ACTIVE AND RENDERED SCENES START for [%s]", s.c_str()));
         for (std::vector<std::string>::iterator it = activeRenderedScenes.begin(); it != activeRenderedScenes.end(); ++it)
         {
            ETG_TRACE_FATAL(("%s", it->c_str()));
         }
         ETG_TRACE_FATAL(("ACTIVE AND RENDERED SCENES END"));
      }
      else
      {
         ETG_TRACE_FATAL(("No Active and Rendered Scenes found for [%s]", s.c_str()));
      }
   }
   else if (queryId == traceQueryId__GET_ALL_ACTIVE_NOTRENDERED_SCENES)
   {
      std::vector<std::string> activeNotRenderedScenes = data->getData().getQueryInput();
      if (activeNotRenderedScenes.size() > 0)
      {
         ETG_TRACE_FATAL(("ACTIVE BUT NOT RENDERED SCENES START for [%s]", s.c_str()));
         for (std::vector<std::string>::iterator it = activeNotRenderedScenes.begin(); it != activeNotRenderedScenes.end(); ++it)
         {
            ETG_TRACE_FATAL(("%s", it->c_str()));
         }
         ETG_TRACE_FATAL(("ACTIVE BUT NOT RENDERED SCENES END"));
      }
      else
      {
         ETG_TRACE_FATAL(("No Active but not Rendered Scenes found for [%s]", s.c_str()));
      }
   }
   else if (queryId == traceQueryId__GET_ALL_INACTIVE_SCENES)
   {
      std::vector<std::string> inactiveScenes = data->getData().getQueryInput();
      if (inactiveScenes.size() > 0)
      {
         ETG_TRACE_FATAL(("INACTIVE SCENES START for [%s]", s.c_str()));
         for (std::vector<std::string>::iterator it = inactiveScenes.begin(); it != inactiveScenes.end(); ++it)
         {
            ETG_TRACE_FATAL(("%s", it->c_str()));
         }
         ETG_TRACE_FATAL(("INACTIVE SCENES END"));
      }
      else
      {
         ETG_TRACE_FATAL(("No Inactive Scenes found for [%s]", s.c_str()));
      }
   }
   return true;
}


ETG_I_CMD_DEFINE((TraceCommand, "Get_All_LoadedScenes"))
ETG_I_CMD_DEFINE((TraceCommand, "GET_ALL_LOADEDSCENES %d", ETG_I_CENUM(enViewCategory)))
void GetAllLoadedScenes::TraceCommand(enViewCategory e)
{
   if (GetInstance()._stub)
   {
      GetAllViewsPayload payload(e);
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
