/* ***************************************************************************************
* FILE:          DumpScene.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DumpScene.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "DumpScene.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::DumpScene::
#include "trcGenProj/Header/DumpScene.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

DumpScene& DumpScene::GetInstance()
{
   static DumpScene theInstance;
   return theInstance;
}


DumpScene::DumpScene()
{
   ETG_I_REGISTER_FILE();
}


DumpScene::~DumpScene()
{
   ETG_I_UNREGISTER_FILE();
}


void DumpScene::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< DumpScenePayload > >& payload)
{
   if (_stub)
   {
      std::vector<int> pids;
      std::vector<std::string > param;
      param.push_back(payload->get0().viewName);
      if (_stub->getClientsPid(payload->get0().appName, pids))
      {
         for (std::vector<int>::iterator it = pids.begin(); it != pids.end(); ++it)
         {
            _stub->sendTraceQuerySignal(TraceQueryData(*it, traceQueryId__DUMP_SCENE, param));
         }
      }
      else
      {
         ETG_TRACE_FATAL(("Unknown application '%s'", payload->get0().appName.c_str()));
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "DumpScene %16s %s", ETG_I_STRING, ETG_I_STRING))
void DumpScene::TraceCommand(const char* appName, const char* ViewID)
{
   if (GetInstance()._stub)
   {
      DumpScenePayload payload(appName, ViewID);
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
