/* ***************************************************************************************
* FILE:          DumpCanderaPerfMeasures.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DumpCanderaPerfMeasures.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "DumpCanderaPerfMeasures.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::DumpCanderaPerfMeasures::
#include "trcGenProj/Header/DumpCanderaPerfMeasures.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

DumpCanderaPerfMeasures& DumpCanderaPerfMeasures::GetInstance()
{
   static DumpCanderaPerfMeasures theInstance;
   return theInstance;
}


DumpCanderaPerfMeasures::DumpCanderaPerfMeasures()
{
   ETG_I_REGISTER_FILE();
}


DumpCanderaPerfMeasures::~DumpCanderaPerfMeasures()
{
   ETG_I_UNREGISTER_FILE();
}


void DumpCanderaPerfMeasures::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< DumpCanderaPerfMeasuresPayload > >& payload)
{
   if (_stub)
   {
      if (payload->get0().empty())
      {
         _stub->sendTraceQuerySignal(TraceQueryData(0, traceQueryId__DUMP_CANDERA_PERF_MEASURES, std::vector< ::std::string >()));
      }
      else
      {
         std::vector<int> pids;
         if (_stub->getClientsPid(payload->get0(), pids))
         {
            for (std::vector<int>::iterator it = pids.begin(); it != pids.end(); ++it)
            {
               _stub->sendTraceQuerySignal(TraceQueryData(*it, traceQueryId__DUMP_CANDERA_PERF_MEASURES, std::vector< ::std::string >()));
            }
         }
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "DumpCanderaPerfMeasures"))
void DumpCanderaPerfMeasures::TraceCommand()
{
   if (GetInstance()._stub)
   {
      DumpCanderaPerfMeasuresPayload payload;
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "DumpCanderaPerfMeasures %s", ETG_I_STRING))
void DumpCanderaPerfMeasures::TraceCommand(const char* appName)
{
   if (GetInstance()._stub)
   {
      DumpCanderaPerfMeasuresPayload payload = appName;
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
