/* ***************************************************************************************
* FILE:          view_includes.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  view_includes.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "View/MessagingDefines.h"

#ifdef VARIANT_S_FTR_ENABLE_COURIERMESSAGING

#include "CanderaWidget/String/String.h"
#include "CanderaPlatform/OS/CanderaTypes.h"
#include "Courier/Version.h"
#include "Courier/Base.h"
#include "Courier/Foundation/Component.h"
#include "Courier/Platform/Types.h"
#include "Courier/Visualization/ViewId.h"
#include "Courier/Messaging/MessageReceiverPreprocessor.h"
#include "Courier/Messaging/MessageReferrer.h"
#include "FeatStd/Platform/CriticalSectionLocker.h"
#include "View/CGI/CgiExtensions/CourierMessageMapper.h"

#include "View/CGI/CgiExtensions/CourierMsgQueue2ASF.h"

#ifdef VIEW_INCLUDES__GUI_SUPPORT
#include "Courier/Visualization/IViewHandler.h"
#include "Courier/Visualization/ViewComponent.h"
#include "Courier/Foundation/ControllerComponent.h"
#include "Courier/Foundation/ModelComponent.h"
#include "Courier/Diagnostics/TraceControl.h"
#include "CanderaAssetLoader/AssetLoaderBase/FileAssetRepository.h"
#include "Courier/Messaging/ComponentMessageReceiver.h"
#include "Courier/Visualization/RenderComponent.h"
#include "Courier/Visualization/ViewHandler.h"
#include "Courier/Visualization/ViewFactory.h"
#include "Courier/Visualization/ViewControllerFactory.h"
#include "AppBase/AppControllerBase.h"
#include "AppBase/ScreenBrokerClient/ScreenBrokerClient.h"
#include "View/CGI/CgiExtensions/ViewControllerBase.h"
// additional files for special project stuff
#include "CanderaWidget/Widget.h"

namespace Courier {
extern bool Init();   // to prevent big big Courier.h include
}


#endif


#endif // VARIANT_S_FTR_ENABLE_COURIERMESSAGING
