/* ***************************************************************************************
* FILE:          WidgetController.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WidgetController.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "WidgetController.h"
#include <CanderaWidget/WidgetBase/WidgetBase.h>
#include <View/CGI/CgiExtensions/AppViewHandler.h>


#include <hmi_trace_if.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_WIDGET
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/WidgetController.cpp.trc.h"
#endif

namespace hmibase {
namespace widget {


using ::Candera::Char;
CANDERA_RTTI_BASECLASS_DEFINITION(WidgetController)
CANDERA_RTTI_BASECLASS_DEFINITION(WidgetControllerData)
CANDERA_RTTI_BASECLASS_DEFINITION(WidgetControllerEvent)


/*****************************************************************************/
void WidgetController::Attach(DelegateWidget& widget)
{
   WidgetControllerData* data = widget.GetControllerData();
   if (data == NULL)
   {
      widget.SetControllerData(CreateData(widget));
   }
}


/*****************************************************************************/
void WidgetController::Detach(DelegateWidget& widget)
{
   WidgetControllerData* data = widget.GetControllerData();
   if (data != NULL)
   {
      widget.SetControllerData(NULL);
      FEATSTD_DELETE(data);
   }
}


/*****************************************************************************/
void WidgetController::DestroyData(DelegateWidget&, WidgetControllerData* data)
{
   if (data != NULL)
   {
      FEATSTD_DELETE(data);
   }
}


/*****************************************************************************/
Courier::TouchInfo WidgetController::GetCurrentSessionTouchInfo(const DelegateWidget&) const
{
   return (AppViewHandler::getInstance().GetTouchSession() != NULL) ? AppViewHandler::getInstance().GetTouchSession()->GetTouchInfo() : Courier::TouchInfo(0, 0, 0, 0, 0);
}


/*****************************************************************************/
Courier::TouchInfo WidgetController::GetCurrentSessionStartTouchInfo(const DelegateWidget&) const
{
   return (AppViewHandler::getInstance().GetTouchSession() != NULL) ? AppViewHandler::getInstance().GetTouchSession()->GetStartTouchInfo() : Courier::TouchInfo(0, 0, 0, 0, 0);
}


}
}
