/* ***************************************************************************************
* FILE:          TouchEventPreprocessor.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TouchEventPreprocessor.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(TouchHandling_TouchEventPreprocessor_h)
#define TouchHandling_TouchEventPreprocessor_h

#include <Courier/Messaging/MessageReceiverPreprocessor.h>
#include <Courier/Platform/CriticalSection.h>
#include <Courier/Messaging/MessageReferrer.h>
#include <Courier/Util/LinkedList.h>

namespace Courier {
class Message;
class TouchMsg;
}


namespace Courier {
namespace TouchHandling {

///
class TouchEventPreprocessor : public Courier::MessageReceiverPreprocessor
{
   public:
      ///
      TouchEventPreprocessor();
      ///
      virtual ~TouchEventPreprocessor();
      ///
      virtual bool Process();
      ///
      void SetWakeupTouchEventThreshold(UInt32 touchEventThreshold);

      ///
      bool Receive(Message* msgPtr);
      ///
      size_t GetSize() const;
      ///
      bool Exists(const TouchMsg* touchMsg) const;

   protected:
      ///
      virtual void TriggerMessageReceiverWakeup();

   private:
      typedef Courier::Internal::SingleLinkedList<Courier::MessageReferrer> MessageList;

      /// Critical section for message list access
      Courier::Platform::CriticalSection mMsgListCs;

      /// List for queuing messages
      MessageList mMsgList;

      ///
      UInt32 mOccurredTouchEvents;
      ///
      UInt32 mTouchEventThreshold;
};


}
}


#endif
