/* ***************************************************************************************
* FILE:          WaylandEventHook.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WaylandEventHook.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(InputHandling_Wayland_WaylandEventHook_h)
#define InputHandling_Wayland_WaylandEventHook_h

#include <FeatStd/Base.h>
#include <View/CGI/InputHandling/Wayland/WaylandInc.h>

// Forward declarations
namespace Courier {
class Message;
}


namespace Courier {
namespace InputHandling {
namespace Wayland {

class WaylandContext;
class WLSeat;

/// @addtogroup COURIER_PLATFORM_WAYLAND
/// @{
/** The class WaylandInputHandler::Hook can be used to overwrite
    the default wayland event to Courier message mapping.
    In case a hook method returns a valid message pointer (!= 0) then
    the default event mapping in the WaylandInputHandler is ignored.
    If the return value equals 0 then the internal default mapping will be executed
    (if any exists). */
class WaylandEventHook
{
   public:
      ///
      WaylandEventHook() {}

      ///
      virtual ~WaylandEventHook() {}

      /// For detailed interface description see Wayland client protocol documentation (wl_pointer_listener)
      virtual Message* OnPointerEventEnter(WLSeat* wlseat,
                                           struct wl_pointer* pointer,
                                           uint32_t serial,
                                           struct wl_surface* surface,
                                           wl_fixed_t surface_x,
                                           wl_fixed_t surface_y)
      {
         FEATSTD_UNUSED2(wlseat, pointer);
         FEATSTD_UNUSED4(serial, surface, surface_x, surface_y);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_pointer_listener)
      virtual Message* OnPointerEventLeave(WLSeat* wlseat,
                                           struct wl_pointer* pointer,
                                           uint32_t serial,
                                           struct wl_surface* surface)
      {
         FEATSTD_UNUSED4(wlseat, pointer, serial, surface);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_pointer_listener)
      virtual Message* OnPointerEventMotion(WLSeat* wlseat,
                                            struct wl_pointer* pointer,
                                            uint32_t /*time*/,
                                            wl_fixed_t surface_x,
                                            wl_fixed_t surface_y)
      {
         FEATSTD_UNUSED4(wlseat, pointer, surface_x, surface_y);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_pointer_listener)
      virtual Message* OnPointerEventButton(WLSeat* wlseat,
                                            struct wl_pointer* pointer,
                                            uint32_t serial,
                                            uint32_t /*time*/,
                                            uint32_t button,
                                            uint32_t state)
      {
         FEATSTD_UNUSED2(wlseat, pointer);
         FEATSTD_UNUSED3(serial, button, state);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_pointer_listener)
      virtual Message* OnPointerEventAxis(WLSeat* wlseat,
                                          struct wl_pointer* pointer,
                                          uint32_t /*time*/,
                                          uint32_t axis,
                                          wl_fixed_t value)
      {
         FEATSTD_UNUSED4(wlseat, pointer, axis, value);
         return 0;
      }

      ///
      virtual Message* PointerHandleFrame(WLSeat* wlseat,
                                          struct wl_pointer* pointer)
      {
         FEATSTD_UNUSED2(wlseat, pointer);
         return 0;
      }

      ///
      virtual Message*  PointerHandleAxis_source(WLSeat* wlseat,
            struct wl_pointer* pointer,
            uint32_t source)
      {
         FEATSTD_UNUSED3(wlseat, pointer, source);
         return 0;
      }

      ///
      virtual Message*  PointerHandleAxis_stop(WLSeat* wlseat,
            struct wl_pointer* pointer,
            uint32_t time,
            uint32_t axis)
      {
         FEATSTD_UNUSED4(wlseat, pointer, time, axis);
         return 0;
      }

      ///
      virtual Message*  PointerHandleAxis_discrete(WLSeat* wlseat,
            struct wl_pointer* pointer,
            uint32_t axis,
            int32_t discrete)
      {
         FEATSTD_UNUSED4(wlseat, pointer, axis, discrete);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_keyboard_listener)
      virtual Message* OnKeyboardEventKeymap(WLSeat* wlseat,
                                             struct wl_keyboard* keyboard,
                                             uint32_t format,
                                             int32_t fd,
                                             uint32_t size)
      {
         FEATSTD_UNUSED5(wlseat, keyboard, format, fd, size);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_keyboard_listener)
      virtual Message* OnKeyboardEventEnter(WLSeat* wlseat,
                                            struct wl_keyboard* keyboard,
                                            uint32_t serial,
                                            struct wl_surface* surface,
                                            struct wl_array* keys)
      {
         FEATSTD_UNUSED5(wlseat, keyboard, serial, surface, keys);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_keyboard_listener)
      virtual Message* OnKeyboardEventLeave(WLSeat* wlseat,
                                            struct wl_keyboard* keyboard,
                                            uint32_t serial,
                                            struct wl_surface* surface)
      {
         FEATSTD_UNUSED4(wlseat, keyboard, serial, surface);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_keyboard_listener)
      virtual Message* OnKeyboardEventKey(WLSeat* wlseat,
                                          struct wl_keyboard* keyboard,
                                          uint32_t serial,
                                          uint32_t /*time*/,
                                          uint32_t key,
                                          uint32_t state)
      {
         FEATSTD_UNUSED2(wlseat, keyboard);
         FEATSTD_UNUSED3(serial, key, state);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_keyboard_listener)
      virtual Message* OnKeyboardEventModifiers(WLSeat* wlseat,
            struct wl_keyboard* keyboard,
            uint32_t serial,
            uint32_t mods_depressed,
            uint32_t mods_latched,
            uint32_t mods_locked,
            uint32_t group)
      {
         FEATSTD_UNUSED2(wlseat, keyboard);
         FEATSTD_UNUSED5(serial, mods_depressed, mods_latched, mods_locked, group);
         return 0;
      }

      virtual Message* KeyboardHandleRepeatInfo(WLSeat* wlseat,
            struct wl_keyboard* keyboard,
            int32_t rate,
            int32_t delay)
      {
         FEATSTD_UNUSED4(wlseat, keyboard, rate, delay);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_touch_listener)
      virtual Message* OnTouchEventDown(WLSeat* wlseat,
                                        struct wl_touch* touch,
                                        uint32_t serial,
                                        uint32_t /*time*/,
                                        struct wl_surface* surface,
                                        int32_t id,
                                        wl_fixed_t x,
                                        wl_fixed_t y)
      {
         FEATSTD_UNUSED3(wlseat, touch, serial);
         FEATSTD_UNUSED4(surface, id, x, y);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_touch_listener)
      virtual Message* OnTouchEventUp(WLSeat* wlseat,
                                      struct wl_touch* touch,
                                      uint32_t serial,
                                      uint32_t /*time*/,
                                      int32_t id)
      {
         FEATSTD_UNUSED4(wlseat, touch, serial, id);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_touch_listener)
      virtual Message* OnTouchEventMotion(WLSeat* wlseat,
                                          struct wl_touch* touch,
                                          uint32_t /*time*/,
                                          int32_t id,
                                          wl_fixed_t x,
                                          wl_fixed_t y)
      {
         FEATSTD_UNUSED2(wlseat, touch);
         FEATSTD_UNUSED3(id, x, y);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_touch_listener)
      virtual Message* OnTouchEventFrame(WLSeat* wlseat,
                                         struct wl_touch* touch)
      {
         FEATSTD_UNUSED2(wlseat, touch);
         return 0;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_touch_listener)
      virtual Message* OnTouchEventCancel(WLSeat* wlseat,
                                          struct wl_touch* touch)
      {
         FEATSTD_UNUSED2(wlseat, touch);
         return 0;
      }
};


/// @}
}


}
}


#endif
