/* ***************************************************************************************
* FILE:          WLSeat.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WLSeat.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef WLSEAT_H_
#define WLSEAT_H_

#include <View/CGI/InputHandling/Wayland/WaylandInc.h>
#include <string.h>

#include "AppUtils/HmiMacros.h"

namespace Courier {
namespace InputHandling {
namespace Wayland {
class WaylandContext;

class WLSeat
{
      // properties
   private:
      struct wl_seat*       _wlSeat;
      struct wl_pointer*    _wlPointer;
      struct wl_keyboard*   _wlKeyboard;
      struct wl_touch*      _wlTouch;
      char* _pSeatName;
      class WaylandContext* _pParentWLContext;
      uint32_t              _seatId;

      HMIBASE_UNCOPYABLE(WLSeat)

      struct wl_surface* _pKeyboardFocus;
      struct wl_surface* _pPointerFocus;
      struct wl_surface* _pTouchFocus;

      uint32_t _keyboardsurfaceID;
      uint32_t _pointersurfaceID;
      uint32_t _touchsurfaceID;

   public:

      WLSeat()
         : _wlSeat(NULL)
         , _wlPointer(NULL)
         , _wlKeyboard(NULL)
         , _wlTouch(NULL)
         , _pSeatName(NULL)
         , _pParentWLContext(NULL)
         , _seatId(0)
         , _pKeyboardFocus(NULL)
         , _pPointerFocus(NULL)
         , _pTouchFocus(NULL)
         , _keyboardsurfaceID(0)
         , _pointersurfaceID(0)
         , _touchsurfaceID(0)
      {
      }
      ~WLSeat()
      {
         if (NULL != _wlPointer)
         {
            wl_pointer_release(_wlPointer);
            _wlPointer = NULL;
         }
         if (NULL != _wlTouch)
         {
            wl_touch_release(_wlTouch);
            _wlTouch = NULL;
         }
         if (NULL != _wlKeyboard)
         {
            wl_keyboard_release(_wlKeyboard);
            _wlKeyboard = NULL;
         }
         if (NULL != _wlSeat)
         {
            wl_seat_destroy(_wlSeat);
            _wlSeat = NULL;
         }
         if (NULL != _pSeatName)
         {
            free(_pSeatName);
         }
         _pParentWLContext = NULL;
         _pKeyboardFocus = NULL;
         _pPointerFocus = NULL;
         _pTouchFocus = NULL;
      }
      struct wl_pointer* GetWLPointer() const
      {
         return _wlPointer;
      }
      struct wl_keyboard* GetWLKeyboard() const
      {
         return _wlKeyboard;
      }
      struct wl_touch* GetWLTouch() const
      {
         return _wlTouch;
      }
      struct wl_seat* GetWLSeat() const
      {
         return _wlSeat;
      }
      WaylandContext* GetParentWlContext()
      {
         return _pParentWLContext;
      }
      char* GetSeatName()
      {
         return _pSeatName;
      }
      struct wl_surface* GetKeyboardFocus()
      {
         return _pKeyboardFocus;
      }
      struct wl_surface* GetPointerFocus()
      {
         return _pPointerFocus;
      }
      struct wl_surface*  GetTouchFocus()
      {
         return _pTouchFocus;
      }
      uint32_t GetKeyboardSurfaceID()
      {
         return _keyboardsurfaceID;
      }
      uint32_t GetPointerSurfaceID()
      {
         return _pointersurfaceID;
      }
      uint32_t GetTouchSurfaceID()
      {
         return _touchsurfaceID;
      }
      void SetWLSeat(struct wl_seat* wlSeat)
      {
         _wlSeat = wlSeat;
      }
      void SetParentWlContext(WaylandContext* pWlContext)
      {
         _pParentWLContext = pWlContext;
      }
      void SetSeatName(const char* pSeatName)
      {
         _pSeatName = strdup(pSeatName);
      }
      void SetWLPointer(struct wl_pointer* wlPointer)
      {
         _wlPointer = wlPointer;
      }
      void SetWLKeyboard(struct wl_keyboard* wlKeyboard)
      {
         _wlKeyboard = wlKeyboard;
      }
      void SetWLTouch(struct wl_touch* wlTouch)
      {
         _wlTouch = wlTouch;
      }
      void setSeatId(uint32_t id)
      {
         _seatId = id;
      }
      void SetKeyboardFocus(struct wl_surface* surface)
      {
         _pKeyboardFocus = surface;
      }
      void SetPointerFocus(struct wl_surface* surface)
      {
         _pPointerFocus = surface;
      }
      void SetTouchFocus(struct wl_surface* surface)
      {
         _pTouchFocus = surface;
      }
      void SetKeyboardSurfaceID(uint32_t surfaceID)
      {
         _keyboardsurfaceID = surfaceID;
      }
      void SetPointerSurfaceID(uint32_t surfaceID)
      {
         _pointersurfaceID = surfaceID;
      }
      void SetTouchSurfaceID(uint32_t surfaceID)
      {
         _touchsurfaceID = surfaceID;
      }
};


}
}


}

#endif /* WLSEAT_H_ */
