/* ***************************************************************************************
* FILE:          SurfaceInputRegion.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SurfaceInputRegion is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef __HMIBASE_SURFACE_INPUT_REGION__
#define __HMIBASE_SURFACE_INPUT_REGION__


//define this symbol in the configuration/project files (or define it here but only for debug purpose)
//#define VARIANT_S_FTR_ENABLE_SURFACE_INPUT_REGION_MANAGER


struct wl_surface;
struct wl_region;


namespace hmibase {
namespace input {

/* Provides a handle to manipulate the input region for a window surface using Wayland.
* It only works for Genivi window surfaces on the target.

SurfaceInputRegion* handle = SurfaceInputRegion::create(rt);
if (handle != NULL)
{
   handle->add(0, 0, 800, 480);//add complete viewport
   handle->add(1000, 1000, 100, 100);//add another rectangle
   handle->subtract(300, 100, 200, 100);//make a hole which is untouchable
   handle->flush();
   SurfaceInputRegion::destroy(handle);
   handle = NULL;
}


*/
class SurfaceInputRegion
{
   public:
      /* destructor */
      ~SurfaceInputRegion();

      /* creates an input region handle for the specified render target */
      static SurfaceInputRegion* create(Candera::RenderTarget* renderTarget);

      /* destroys the specified input region handle */
      static void destroy(SurfaceInputRegion* handle);

      /* flushes the input region to Wayland and release resources. after flushing, the handle is not valid anymore and must be destroyed */
      void flush();

      /* adds a rectangle to this handle which will be touchable */
      void add(int x, int y, int width, int height);

      /* subtracts a rectangle from this handle which will be untouchable*/
      void subtract(int x, int y, int width, int height);

      /* returns the surface id */
      unsigned int getSurfaceId() const
      {
         return _surfaceId;
      }

   private:
      SurfaceInputRegion();
      SurfaceInputRegion(const SurfaceInputRegion&);
      SurfaceInputRegion& operator=(const SurfaceInputRegion&);

      /* private constructor. use create to obtain a new handle */
      SurfaceInputRegion(unsigned int surfaceId, wl_surface* wlSurface, wl_region* wlRegion);

      unsigned int _surfaceId;
      wl_surface* _wlSurface;
      wl_region* _wlRegion;
};


}
}


#endif
