/* ***************************************************************************************
* FILE:          InputThreadHook.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  InputThreadHook.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(InputHandling_InputThreadHook_h)
#define InputHandling_InputThreadHook_h

#include <Courier/Base.h>

// ------------------------------------------------------------------------
namespace Courier {
namespace InputHandling {
/** Input handler thread hook, which may be attached to a input handler for interfering the various thread stages,
    like startup, processing and termination. */
class InputThreadHook
{
   public:
      ///
      virtual ~InputThreadHook() {}
      /** Startup hook method for an InputThread, called once before the thread execution loop.
          @param data User data provided in InputThread, there this hook is attached to.
          @return If this hook method returns false, the thread will terminate without entering the thread execution loop. */
      virtual bool OnStartup(void* data)
      {
         FEATSTD_UNUSED(data);
         return true;
      }

      /** Execution hook method for an InputThread, called on the beginning of every thread execution loop cycle.
          @param data User data provided in InputThread, there this hook is attached to.
          @return If this hook method returns false, the thread will terminate the execution loop. */
      virtual bool OnExecute(void* data)
      {
         FEATSTD_UNUSED(data);
         return true;
      }

      /** Shutdown hook method for an InputThread, called once after the thread execution loop has finished.
          @note This hook method is also called if the thread execution loop was not entered before
          (means when OnStartup() has returned 'false').
          @param data User data provided in InputThread, there this hook is attached to. */
      virtual void OnShutdown(void* data)
      {
         FEATSTD_UNUSED(data);
      }
};


}
}


#endif
