/* ***************************************************************************************
* FILE:          GenericConsoleInputHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GenericConsoleInputHandler.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(InputHandling_Generic_GenericConsoleInputHandler_h)
#define InputHandling_Generic_GenericConsoleInputHandler_h

#include <View/CGI/InputHandling/InputHandler.h>

// Forward declarations
namespace Courier {
class Message;
}


namespace Courier {
namespace InputHandling {
namespace Generic {
/// @addtogroup COURIER_PLATFORM_GENERIC
/// @{
class GenericConsoleInputHandler : public InputHandler
{
      typedef InputHandler Base;
   public:
      class Hook
      {
         public:
            virtual Message* OnEvent(Int event) = 0;
      };

      ///
      virtual bool Listen();

   private:
      // Do not allow to change mode, as only Blocking mode is available with this input handler
      virtual void SetMode(InputHandlerMode::Enum mode);
};


/// @}
}


}
}


#endif
