/* ***************************************************************************************
* FILE:          DisplayInputContext.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DisplayInputContext.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(InputHandling_DisplayInputContext_h)
#define InputHandling_DisplayInputContext_h

#include <Courier/Base.h>
#include <Courier/Util/LinkedList.h>

namespace Candera {
class Display;
class ContextResourcePool;
}


namespace Courier {
namespace InputHandling {
struct DisplayConfiguration;
class InputHandler;
class InputThreadHook;
class InputThread;

// External input handling context
class DisplayInputContext
{
   public:
      ///
      DisplayInputContext();

      /** Attaches the native handle needed for event queue listening (optional, e.g. for window event queues).
          @param handle Native handle, which represents the event queue. */
      void SetNativeHandle(void* nativeHandle);

      ///
      void SetDisplay(Candera::Display* display);

      ///
      void SetDisplayConfiguration(DisplayConfiguration* displayConfiguration);

      ///
      void SetInputHandler(InputHandler* inputHandler,
                           void* inputEventHook);

      ///
      void SetInputThread(InputThread* inputThread,
                          const Char* inputThreadName,
                          InputThreadHook* inputThreadHook);

      ///
      void Run();

      ///
      void Terminate();

      ///
      void Reset();

      ///
      FEATSTD_LINT_NEXT_EXPRESSION(1763, "the object itself is still const")
      void* GetNativeHandle() const
      {
         return mNativeHandle;
      }

      ///
      FEATSTD_LINT_NEXT_EXPRESSION(1763, "the object itself is still const")
      Candera::Display* GetDisplay() const
      {
         return mDisplay;
      }

      ///
      FEATSTD_LINT_NEXT_EXPRESSION(1763, "the object itself is still const")
      DisplayConfiguration* GetDisplayConfiguration() const
      {
         return mDisplayConfiguration;
      }

      ///
      FEATSTD_LINT_NEXT_EXPRESSION(1763, "the object itself is still const")
      InputHandler* GetInputHandler() const
      {
         return mInputHandler;
      }

      ///
      FEATSTD_LINT_NEXT_EXPRESSION(1763, "the object itself is still const")
      InputThread* GetInputThread() const
      {
         return mInputThread;
      }

   private:
      ///
      InputHandler* mInputHandler;
      ///
      InputThread* mInputThread;
      ///
      DisplayConfiguration* mDisplayConfiguration;
      ///
      Candera::Display* mDisplay;
      ///
      Candera::ContextResourcePool* mContextResourcePool;
      ///
      void* mNativeHandle;
};


}
}


#endif
