/* ***************************************************************************************
* FILE:          DisplayConfiguration.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DisplayConfiguration.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(InputHandling_DisplayConfiguration_h)
#define InputHandling_DisplayConfiguration_h

#include <Courier/Base.h>
#include <CanderaPlatform/Device/Common/Base/Display.h>

namespace Courier {
namespace InputHandling {
// Forward declarations
class InputHandler;

/// Application display configuration type
struct DisplayConfiguration
{
   ///
   FeatStd::Int displayId;
   ///
   const FeatStd::Char* displayName;
   ///
   Candera::Display::CommonSettings displaySettings;
};


}
}


#endif
