/* ***************************************************************************************
* FILE:          DataBindingTrace.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DataBindingTrace.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "DataBindingTrace.h"
#include "Courier/Messaging/Message.h"
#include "View/CGI/CgiExtensions/DataBindingRealm.h"
#include "View/CGI/CourierMsgTracing/CourierMessageMapTrace.h"
#include "hmi_trace_if.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_DATABINDING
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/DataBindingTrace.cpp.trc.h"
#endif

namespace hmibase {
namespace view {
namespace DataBindingTrace {
void Trace(const Courier::Message* msg)
{
   if (etg_bIsTraceActiveDouble(((0xFFFFu & (etg_tU16)(TR_CLASS_HMI_DATABINDING)) << 16) | (etg_tU16)(ETG_LEVEL_USER_4), (etg_tU16)APP_DATABINDING_TRACECLASS_ID()) == true)
   {
      std::string s = CourierMessageMapTrace::getMessagePayload(*msg).c_str();
      size_t idx = 0;
      size_t length = s.length();
      const size_t stepSize = ETG_C_TRACE_MAX - 22; // max length for TTFis traces, header size of 22 for ETG_TRACE_USR4_THR_DCL, and can print 217 bytes.
      //For other ETG MACRO, header size is 20 and can print 219 bytes (ETG_TRACE_USR4,ETG_TRACE_USR4_THR and ETG_TRACE_USR4_DCL)
      ETG_TRACE_USR4_THR_DCL((APP_DATABINDING_TRACECLASS_ID(), "Courier::DataItemMsg payload BEGIN"));
      while (idx < length)
      {
         ETG_TRACE_USR4_THR_DCL((APP_DATABINDING_TRACECLASS_ID(), "%s", s.substr(idx, stepSize).c_str()));
         idx += stepSize;
      }
      ETG_TRACE_USR4_THR_DCL((APP_DATABINDING_TRACECLASS_ID(), "Courier::DataItemMsg payload END"));
   }
}


}
}


}
