/* ***************************************************************************************
* FILE:          CourierMessageMapTrace.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CourierMessageMapTrace.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __CourierMessageMapTrace_H_
#define __CourierMessageMapTrace_H_

#include <string>
namespace Courier {
class Message;
}


class CourierMessageMapTrace
{
   public:
      enum CourierComponent
      {
         Framework_Component = 0,
         Model_Component,
         View_Component,
         Controller_Component,
         Unknown_Component
      };

      static CourierComponent getComponent(unsigned int traceclass);
      static std::string getMessagePayload(const Courier::Message& msg);
};


#endif
