/* ***************************************************************************************
* FILE:          CourierMessageMapTrace.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CourierMessageMapTrace.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "Courier/Messaging/Message.h"

#include "hmi_trace_if.h"
#include "CourierMessageMapTrace.h"

std::string CourierMessageMapTrace::getMessagePayload(const Courier::Message& msg)
{
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
   FeatStd::Internal::FixedSizeString<1000> buf;
   FeatStd::FixedSizeStringBuffer<1000> strBuf(buf);

   strBuf.AppendObject(msg);
   return buf.CStr();
#else
   return "Courier Message Payload appender not enabled";
#endif
}


CourierMessageMapTrace::CourierComponent CourierMessageMapTrace::getComponent(unsigned int traceclass)
{
   CourierComponent compId = Unknown_Component;

   if (traceclass % (64) == TR_CLASSOFFSET_APPHMI_CPL_MODEL)
   {
      compId = Model_Component;
   }
   else if (traceclass % (64) == TR_CLASSOFFSET_APPHMI_CPL_VIEW)
   {
      compId = View_Component;
   }
   else if (traceclass % (64) == TR_CLASSOFFSET_APPHMI_CPL_CONTROLLER)
   {
      compId = Controller_Component;
   }
   else if ((traceclass / TR_CLASS_HMI_FW == 1) && (traceclass % 64 < 32))
   {
      compId = Framework_Component;
   }

   return compId;
}
