/* ***************************************************************************************
* FILE:          ViewComponent.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ViewComponent.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef HMIBASE_VIEW_COMPONENT_H
#define HMIBASE_VIEW_COMPONENT_H

#include <Courier/Visualization/ViewComponent.h>

namespace hmibase {
namespace view {

class MessageHandler;


class ViewComponent : public ::Courier::ViewComponent
{
      typedef ::Courier::ViewComponent Base;

   public:
      ViewComponent();
      virtual ~ViewComponent();

      static void registerMessageHandler(MessageHandler& handler);
      static void unregisterMessageHandler(MessageHandler& handler);

   protected:
      virtual bool OnMessage(const ::Courier::Message& msg);

      static bool dispatchToMessageHandlers(const ::Courier::Message& msg);

      typedef std::vector<MessageHandler*> MessageHandlersType;
      static MessageHandlersType _messageHandlers;
};


}
}


#endif // HMIBASE_VIEWSCENE_H
