/* ***************************************************************************************
* FILE:          SurfaceUtils.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SurfaceUtils is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef __HMIBASE_SURFACE_UTILS__
#define __HMIBASE_SURFACE_UTILS__

#include "hmibase/util/Macros.h"

namespace Candera {
class Camera2D;
class Surface;
class Vector2;
}


namespace hmibase {
namespace view {
namespace util {


/************************************************************************/
typedef unsigned int SurfaceIdType;
typedef unsigned int DisplayIdType;


/************************************************************************/
class SurfaceUtils
{
   public:
      /* Returns the surface id of the specified surface(render target). */
      static SurfaceIdType getSurfaceId(const Candera::Surface& surface);

      /* Returns the display id of the specified surface id. */
      static DisplayIdType getDisplayId(SurfaceIdType surfaceId);

      /* Returns the display id of the specified surface(render target). */
      static DisplayIdType getDisplayId(const Candera::Surface& surface);

      /* Transforms the specified coordinate from scene space to display space.
      * Can be used to determine the display coordinate where a node is rendered.
      */
      static bool transformSceneToDisplay(Candera::Camera2D& camera, Candera::Vector2& coordinate);

      /* Transforms the specified coordinate from scene space to surface space.
      * Can be used to determine the surface coordinate where a node is rendered.
      */
      static bool transformSceneToSurface(Candera::Camera2D& camera, Candera::Vector2& coordinate);

      /* Marks the specified rectangle of a surface as touchable. */
      static void sendTouchableRectangle(SurfaceIdType surfaceId, const Candera::Rectangle& rectangle);

   private:
      FEATSTD_MAKE_CLASS_STATIC(SurfaceUtils);
};


}
}


}
HMIBASE_DEPRECATED_TYPE_ALIAS(SurfaceUtils, ::hmibase::view::util::SurfaceUtils);

#endif
