/* ***************************************************************************************
* FILE:          ShaderStorage.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ShaderStorage is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_VIEW_SHADERSTORAGE_H
#define HMIBASE_VIEW_SHADERSTORAGE_H

#include "CanderaConfig.h"

#ifdef CANDERA_SHADER_PROGRAM_PERSIST_INTERFACE_ENABLED

#if (defined FEATSTD_PLATFORM_OS_Win32) || (defined FEATSTD_PLATFORM_OS_Posix)

#include <CanderaPlatform/Device/Common/OpenGLES/GlShaderStorageInterface.h>
#include <map>
#include <string>

namespace hmibase {
namespace util {
class Semaphore;
}


namespace view {

/**
* @brief SampleShaderStorage represents class used for storing binary shaders to persistent memory.
*/
class ShaderStorage : public Candera::GlShaderStorageInterface
{
   public:
      ShaderStorage();
      explicit ShaderStorage(bool useApplicationFolder);
      virtual ~ShaderStorage();

      virtual bool Retrieve(StorageObject& object) override;

      virtual bool Persist(StorageObject& object) override;

   protected:

      static void CleanupProc(StorageObject* object);

      enum
      {
         DescriptorSize = 37 //maximum file name length including NULL terminator
      };

   private:

      bool Lock(const char* descriptor);
      bool Unlock(const char* descriptor);

      std::string FormatShaderBinaryPath(const char* descriptor);

      bool CustomIdentifierMd5(std::string& shaderText, FeatStd::UInt8* object, FeatStd::SizeType size);

      typedef std::map<std::string, hmibase::util::Semaphore*> SemaphoreMap;
      SemaphoreMap semaphores;
      bool _useApplicationFolder;
      std::string _shaderBinaryFolder;
};


}
}


#endif // FEATSTD_PLATFORM_OS_Win32
#endif // CANDERA_SHADER_PROGRAM_PERSIST_INTERFACE_ENABLED
#endif
