/* ***************************************************************************************
* FILE:          SceneTransitionMediator.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SceneTransitionMediator.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __SceneTransitionMediator_H
#define __SceneTransitionMediator_H

#include "Courier/Visualization/ViewFacade.h"
#include "View/CGI/CgiExtensions/DataCompletionHandler.h"

namespace hmibase {
   namespace view {
      class SceneTransitionMediatorPair : public IDataCompletionListener
      {
      public:
         SceneTransitionMediatorPair(Courier::IViewHandler* viewHandler);
         virtual ~SceneTransitionMediatorPair();

         void cleanup();
         bool checkTransition(Courier::IViewHandler* viewHandler);
         void onDataComplete(TransitionHint hint);
         bool setListenerLeave(bool add, FeatStd::UInt32 timeout = 350);
         bool setListenerEnter(bool add, FeatStd::UInt32 timeout = 350);
         //private:
         TransitionHint  _hint;
         Courier::ViewId _viewIdEnter;
         Courier::ViewId _viewIdLeave;
         Courier::View*  _viewLeave;
         Courier::View*  _viewEnter;
         Courier::ViewFacade _viewFacade;
      };


      // The SceneTransitionMediatorHandler object is responsible for holding a
      // list of possible transition mediator implementations.

      class SceneTransitionMediator
      {
      public:
         SceneTransitionMediator();
         virtual ~SceneTransitionMediator();
         // Initializes the SceneTransitionMediator.
         bool init(Courier::IViewHandler* viewHandler);
         void enter(const Courier::ViewId& view, TransitionHint hint);
         void leave(const Courier::ViewId& view, TransitionHint hint);
         bool check(TransitionHint hint);
         void onDataComplete(TransitionHint hint);
         SceneTransitionMediatorPair* findHint(TransitionHint hint);
         SceneTransitionMediatorPair* allocMediatorPair();

      private:
         Courier::IViewHandler* _viewHandler;
         Courier::Vector< SceneTransitionMediatorPair* >  _sceneMediatorPairList;
      };
   }
}

#endif
