/* ***************************************************************************************
* FILE:          SceneMapping.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SceneMapping.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "SceneMapping.h"
#include <View/CGI/CgiExtensions/ViewScene2D.h>
#include <View/CGI/CgiExtensions/ViewScene3D.h>
#include "hmi_trace_if.h"

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SceneMapping.cpp.trc.h"
#endif

namespace hmibase {
   namespace view {
      Courier::View*  SceneMapping::createView(const Courier::Char* sViewName, SceneMapping* pScenes, unsigned cnt, Courier::IViewHandler* viewHandler)
      {
         HMI_APP_ASSERT(sViewName != 0);
         for (unsigned i = 0; i < cnt; i++)
         {
            if ((sViewName != 0) && (strcmp(pScenes[i]._nameID.CStr(), sViewName) == 0))
            {
               if (pScenes[i]._is3DScene)
               {
                  HMI_APP_ASSERT(pScenes[i]._scene == 0);
                  pScenes[i]._scene = FEATSTD_NEW(hmibase::view::ViewScene3D)();
               }
               else
               {
                  HMI_APP_ASSERT(pScenes[i]._scene == 0);
                  pScenes[i]._scene = FEATSTD_NEW(hmibase::view::ViewScene2D)();
               }
               HMI_APP_ASSERT(pScenes[i]._scene != 0);
               if (pScenes[i]._scene != 0)
               {
                  if (pScenes[i]._scene->Init(viewHandler, sViewName))
                  {
                     return pScenes[i]._scene;
                  }
               }
               else
               {
                  ETG_TRACE_FATAL_THR(("NULL-Pointer in scenemapping for scene %s", sViewName));
               }
            }
         }
         if ((SceneMapping::base != 0) && (SceneMapping::base != pScenes))
         {
            return SceneMapping::createView(sViewName, base, baseCnt, viewHandler);
         }
         return NULL;
      }


      bool SceneMapping::destroyView(SceneMapping* pScenes, unsigned cnt, const Courier::View* view)
      {
         HMI_APP_ASSERT(view != 0);
         for (unsigned i = 0; i < cnt; i++)
         {
            if (pScenes[i]._scene == view  && view)
            {
               FEATSTD_DELETE(pScenes[i]._scene);
               pScenes[i]._scene = NULL;
               return true;
            }
         }
         if ((SceneMapping::base != 0) && (SceneMapping::base != pScenes))
         {
            return SceneMapping::destroyView(base, baseCnt, view);
         }
         return false;
      }


      Courier::ViewController* SceneMapping::createViewController(const Courier::Char* sViewName, const SceneMapping* pScenes, unsigned cnt)
      {
         HMI_APP_ASSERT(sViewName != 0);
         for (unsigned i = 0; i < cnt; i++)
         {
            if ((sViewName != 0) && (strcmp(pScenes[i]._nameID.CStr(), sViewName) == 0))
            {
               return pScenes[i]._fktCreateInstance != 0 ? pScenes[i]._fktCreateInstance() : 0;
            }
         }
         if ((SceneMapping::base != 0) && (SceneMapping::base != pScenes))
         {
            return SceneMapping::createViewController(sViewName, base, baseCnt);
         }
         return NULL;
      }
   }
}