/* ***************************************************************************************
* FILE:          Renderer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Renderer.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(hmibase_Renderer_H)
#define hmibase_Renderer_H

#include <Courier/Visualization/Renderer.h>
#include <map>
#include <vector>

namespace Candera {
class RenderTarget;
}


namespace hmibase {
   namespace view {

      class IRenderObserver
      {
      public:
         // for lint only
         virtual ~IRenderObserver() {}

         virtual void onPreRender() = 0;
         virtual void onPostRender(bool continousExecutionEnabled) = 0;
      };


      class Renderer : public Courier::Renderer
      {
         typedef Courier::Renderer Base;
      public:
         typedef std::map<int, std::vector<unsigned int> > tLayerSurfaceMap;

         Renderer();
         virtual ~Renderer();

         virtual Courier::Gdu* GetGdu(Candera::RenderTarget* renderTarget);

         virtual bool AddGdu(Candera::GraphicDeviceUnit* inGdu);
         virtual bool LoadGdu(Candera::GraphicDeviceUnit* inGdu);
         virtual bool RemoveGdu(Candera::GraphicDeviceUnit* inGdu);

         virtual bool Render(Courier::RenderHint* renderHint);

         const tLayerSurfaceMap& GetLayerSurfaceMap();

         void SetRenderObserver(IRenderObserver* observer)
         {
            _observer = observer;
         }

      private:
         tLayerSurfaceMap _layerSurfaceMap;
         IRenderObserver* _observer;
      };

   }
} // namespace hmibase

#endif // !defined(hmibase_Renderer_H)
