/* ***************************************************************************************
* FILE:          RenderJobStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RenderJobStrategy.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_RENDERJOBSTRATEGY
#define HMIBASE_RENDERJOBSTRATEGY

#include "Courier/Visualization/Renderer.h"
#include <set>
#include <map>

namespace hmibase {
namespace view {
class RenderJobStrategy : public Courier::RenderJobStrategy
{
      typedef Courier::RenderJobStrategy Base;

   public:
      RenderJobStrategy();
      virtual ~RenderJobStrategy();

      using Courier::RenderJobStrategy::EarlySwap;

      void SetEarlySwap(bool value);

      virtual bool OnSwapBuffer(Courier::Gdu& gdu);

      virtual void OnPostSwapBuffer(Courier::Gdu& gdu);

      virtual void TransformDirtyAreaToInvalidationDependency(const FeatStd::Optional<Candera::Rectangle>& dirtyArea,
            FeatStd::Optional<Candera::Rectangle>& transformedDirtyArea, const Courier::View& view,
            const Courier::RenderJobStrategy::InvalidationDependencyData& invalidationDependencyData);

      virtual FeatStd::UInt8 GetEffectiveRenderCounter(const Courier::ViewScene* view, const Candera::CanderaObject& camera, const Courier::Gdu& gdu, FeatStd::UInt8 renderCounter) override;

      virtual bool operator()(const Courier::RenderJob& a, const Courier::RenderJob& b) const;

      // activate/deactivate native swap for given surface
      void WaitForNativeAfterSwap(unsigned int surfaceId, unsigned int count);

      typedef void(*CallbackFunction)(unsigned int surfaceId, bool success, unsigned int remainingCount);

      static void SetEglWaitNativeCallbackFunction(CallbackFunction calbackFunction)
      {
         s_callback = calbackFunction;
      };

      class RenderJobListener
      {
         public:
            virtual void OnPostSwapBuffer(Courier::Gdu& gdu) = 0;
      };

      static void RegisterListener(RenderJobListener* listener);
      static void DeregisterListener(RenderJobListener* listener);

   private:
      // set with surfaceIds for which we should wait for native swap
      std::map<unsigned int, unsigned int> _waitForNativeAfterSwap;

      // map with gdu pointers and associated surfaceIds
      std::map<const Courier::Gdu*, unsigned int> _gdus;

      static std::set<RenderJobListener*> s_renderJobListener;

      unsigned int GetSurfaceId(Courier::Gdu& gdu) const;

      static CallbackFunction s_callback;
};


}
}


#endif
