/* ***************************************************************************************
* FILE:          PopupConfig.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PopupConfig.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __POPUPCONFIG_H__
#define __POPUPCONFIG_H__

#include <string>
#include "View/ViewIdentifier.h"
#include "hmibase/util/Macros.h"

#include <ScreenBroker/Modality.h>
#ifdef VARIANT_S_FTR_ENABLED_SCREENBROKER_ALIGNMENT
#include <ScreenBroker/HorizontalAlignment.h>
#include <ScreenBroker/VerticalAlignment.h>
#endif
//#include <BaseContract/generated/BaseTypes.h>

namespace hmibase {
   namespace view {
      typedef struct ST_POPUP_CONFIG
      {
         ScreenBroker::Modality::Enum enModality;  // application or global

#ifdef VARIANT_S_FTR_ENABLED_SCREENBROKER_ALIGNMENT
         ScreenBroker::HorizontalAlignment::Enum enHorizontalAlignment;
         ScreenBroker::VerticalAlignment::Enum enVerticalAlignment;
#endif
         unsigned int     priority;                     // priority

         unsigned int     presTime;                     // presentation time

         unsigned int     minPresTime;                  // minimum presentation time

         unsigned int     validityPeriod;               // validity period

         bool     closeOnSuperseded;                    //true if the popup has to be closed once superseded

         bool     closeOnAppLeave;                      //true if the popup has to be closed once the corresponding app is closed

         unsigned int     surfaceID;                    // surfaceID for this popup

         ::hmibase::view::ViewIdentifier    viewID;                     // path of the popup in asset

         bool     closeOnExternalTouch;                 //true if the popup has to be closed on touch outside of popup area

         signed int focuspriority;				      //priority to set (keyboard/pointer)focus

         unsigned int     displayID;                    // displayID for this popup
      } ST_POPUP_CONFIG;

      class PopUpConfig {
      public:
         PopUpConfig();
         PopUpConfig(ST_POPUP_CONFIG *popUpConfigTable, int popUpCount);
         static ST_POPUP_CONFIG* FindPopupConfig(
            const ::hmibase::view::ViewIdentifier &viewID,
            unsigned int displayId);

      protected:
         static struct ST_POPUP_CONFIG *_popUpConfigTable;
         static unsigned int _popUpCount;
      };

#define POPUP_TABLE_BEGIN() ::hmibase::view::ST_POPUP_CONFIG  gPopupConfigTable[] = {
#ifdef VARIANT_S_FTR_ENABLED_SCREENBROKER_ALIGNMENT
#define POPUP_TABLE_ENTRY(modality, prio, presTime, minTime, validityPeriod, hAlign, vAlign, closeOnSuperseded, bCloseOnAppLeave, surfaceID, _controllerClass_)  {modality, hAlign, vAlign, prio, presTime, minTime, validityPeriod, closeOnSuperseded, bCloseOnAppLeave, static_cast<unsigned int>(surfaceID), ::hmibase::view::ViewIdentifier(_controllerClass_::_name), false,0, static_cast<unsigned int>(hmibase::DEFAULT_UNKNOWN_DISPLAY)}
#define POPUP_TABLE_ENTRY_EXT(modality, prio, presTime, minTime, validityPeriod, hAlign, vAlign, closeOnSuperseded, bCloseOnAppLeave, surfaceID, _controllerClass_ , closeOnExternalTouch)  {modality, hAlign, vAlign, prio, presTime, minTime, validityPeriod, closeOnSuperseded, bCloseOnAppLeave, static_cast<unsigned int>(surfaceID), ::hmibase::view::ViewIdentifier(_controllerClass_::_name), closeOnExternalTouch,0, static_cast<unsigned int>(hmibase::DEFAULT_UNKNOWN_DISPLAY)}
#define POPUP_TABLE_ENTRY_EXT_WITH_FOCUS_PRIO(modality, prio, presTime, minTime, validityPeriod, hAlign, vAlign, closeOnSuperseded, bCloseOnAppLeave, surfaceID, _controllerClass_ , closeOnExternalTouch, focuspriority)  {modality, hAlign, vAlign, prio, presTime, minTime, validityPeriod, closeOnSuperseded, bCloseOnAppLeave, static_cast<unsigned int>(surfaceID), ::hmibase::view::ViewIdentifier(_controllerClass_::_name), closeOnExternalTouch,focuspriority, static_cast<unsigned int>(hmibase::DEFAULT_UNKNOWN_DISPLAY)}

#else
#define POPUP_TABLE_ENTRY(modality, prio, presTime, minTime, validityPeriod, closeOnSuperseded, bCloseOnAppLeave, surfaceID, _controllerClass_)  {modality, prio, presTime, minTime, validityPeriod, closeOnSuperseded, bCloseOnAppLeave, static_cast<unsigned int>(surfaceID), ::hmibase::view::ViewIdentifier(_controllerClass_::_name),false,0, static_cast<unsigned int>(hmibase::DEFAULT_UNKNOWN_DISPLAY)}
#define POPUP_TABLE_ENTRY_EXT(modality, prio, presTime, minTime, validityPeriod, closeOnSuperseded, bCloseOnAppLeave, surfaceID, _controllerClass_ , closeOnExternalTouch)  { modality, prio, presTime, minTime, validityPeriod, closeOnSuperseded, bCloseOnAppLeave, static_cast<unsigned int>(surfaceID), ::hmibase::view::ViewIdentifier(_controllerClass_::_name), closeOnExternalTouch ,0,static_cast<unsigned int>(hmibase::DEFAULT_UNKNOWN_DISPLAY)}
#define POPUP_TABLE_ENTRY_EXT_WITH_FOCUS_PRIO(modality, prio, presTime, minTime, validityPeriod, closeOnSuperseded, bCloseOnAppLeave, surfaceID, _controllerClass_ , closeOnExternalTouch, focuspriority)  { modality, prio, presTime, minTime, validityPeriod, closeOnSuperseded, bCloseOnAppLeave, static_cast<unsigned int>(surfaceID), ::hmibase::view::ViewIdentifier(_controllerClass_::_name), closeOnExternalTouch ,focuspriority,static_cast<unsigned int>(hmibase::DEFAULT_UNKNOWN_DISPLAY)}
#define POPUP_TABLE_ENTRY_EXT_MULTI_DISPLAY(modality, prio, presTime, minTime, validityPeriod, closeOnSuperseded, bCloseOnAppLeave, surfaceID, _controllerClass_ , closeOnExternalTouch, focuspriority,displayID)  { modality, prio, presTime, minTime, validityPeriod, closeOnSuperseded, bCloseOnAppLeave, static_cast<unsigned int>(surfaceID), ::hmibase::view::ViewIdentifier(_controllerClass_::_name), closeOnExternalTouch ,focuspriority,displayID}

#define POPUP_TABLE_ENTRY_DUMMY() {ScreenBroker::Modality::None, 0, 0, 0, 0, false, false, 0, ::hmibase::view::ViewIdentifier(""), false, 0, static_cast<unsigned int>(hmibase::DEFAULT_UNKNOWN_DISPLAY)}
#endif
#define POPUP_TABLE_END() }; \
  ::hmibase::view::PopUpConfig popUpConfig(&gPopupConfigTable[0], (sizeof(gPopupConfigTable) / sizeof(::hmibase::view::ST_POPUP_CONFIG)));

   }
}

HMIBASE_DEPRECATED_TYPE_ALIAS(ST_POPUP_CONFIG, ::hmibase::view::ST_POPUP_CONFIG);
HMIBASE_DEPRECATED_TYPE_ALIAS(PopUpConfig, ::hmibase::view::PopUpConfig);
#endif  //__POPUPCONFIG_H__
