/* ***************************************************************************************
* FILE:          PopupConfig.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IAppViewSettings.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "PopupConfig.h"
#include <BaseContract/generated/BaseTypes.h>

namespace hmibase {
namespace view {
unsigned int PopUpConfig::_popUpCount = 0;
::hmibase::view::ST_POPUP_CONFIG* PopUpConfig::_popUpConfigTable = 0;

PopUpConfig::PopUpConfig()
{
}


PopUpConfig::PopUpConfig(::hmibase::view::ST_POPUP_CONFIG* popUpConfigTable, int popUpCount)
{
   _popUpConfigTable = popUpConfigTable;
   _popUpCount = popUpCount;
}


::hmibase::view::ST_POPUP_CONFIG* ::hmibase::view::PopUpConfig::FindPopupConfig(const ::hmibase::view::ViewIdentifier& viewID, unsigned int displayId)
{
   if (0 != _popUpConfigTable && 0 < _popUpCount)
   {
      for (unsigned int index = 0; index < _popUpCount; ++index)
      {
         if ((displayId == _popUpConfigTable[index].displayID
               || displayId == hmibase::DEFAULT_UNKNOWN_DISPLAY
               || displayId == 0)
               && _popUpConfigTable[index].viewID == viewID)
         {
            return &(_popUpConfigTable[index]);
         }
      }
   }
   return NULL;
}


}
}
