/* ***************************************************************************************
* FILE:          MessageHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MessageHandler.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __MESSAGE_HANDLER_H__
#define __MESSAGE_HANDLER_H__

#include "hmibase/util/Macros.h"

namespace Courier {
class Message;
}


namespace hmibase {
namespace view {

class MessageHandler
{
   public:
      virtual ~MessageHandler() {}
      virtual bool onMessage(const Courier::Message& msg) = 0;
};


}
}


HMIBASE_DEPRECATED_TYPE_ALIAS(MessageHandler, hmibase::view::MessageHandler);

#endif
