/* ***************************************************************************************
* FILE:          LayoutSizePropertySetter.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LayoutSizePropertySetter.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "gui_std_if.h"
#include "LayoutSizePropertySetter.h"
#include <Candera/Engine2D/Core/Node2D.h>

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/Layouter.h>
#else
#include <Candera/Engine2D/Layout/Layouter.h>
#endif

namespace hmibase {
namespace view {
namespace animation {

FEATSTD_RTTI_DEFINITION(LayoutSizePropertySetter, Candera::Animation::BaseNode2DPropertySetter)
FEATSTD_RTTI_DEFINITION(LayoutSizeXPropertySetter, Candera::Animation::BaseNode2DPropertySetter)
FEATSTD_RTTI_DEFINITION(LayoutSizeYPropertySetter, Candera::Animation::BaseNode2DPropertySetter)


/*****************************************************************************/
void LayoutSizePropertySetter::Set(const FeatStd::Float* value)
{
   Candera::Node2D* node = GetNode();
   if ((node != NULL) && (value != NULL))
   {
      Candera::Layouter::SetSize(*node, Candera::Vector2(value[0], value[1]));
   }
}


/*****************************************************************************/
LayoutSizePropertySetter::SharedPointer LayoutSizePropertySetter::Create()
{
   return LayoutSizePropertySetter::SharedPointer(CANDERA_NEW(LayoutSizePropertySetter));
}


/*****************************************************************************/
void LayoutSizeXPropertySetter::Set(const FeatStd::Float* value)
{
   Candera::Node2D* node = GetNode();
   if ((node != NULL) && (value != NULL))
   {
      Candera::Layouter::SetSize(*node, Candera::Vector2(value[0], Candera::Layouter::GetSize(*node).GetY()));
   }
}


/*****************************************************************************/
LayoutSizeXPropertySetter::SharedPointer LayoutSizeXPropertySetter::Create()
{
   return LayoutSizeXPropertySetter::SharedPointer(CANDERA_NEW(LayoutSizeXPropertySetter));
}


/*****************************************************************************/
void LayoutSizeYPropertySetter::Set(const FeatStd::Float* value)
{
   Candera::Node2D* node = GetNode();
   if ((node != NULL) && (value != NULL))
   {
      Candera::Layouter::SetSize(*node, Candera::Vector2(Candera::Layouter::GetSize(*node).GetX(), value[0]));
   }
}


/*****************************************************************************/
LayoutSizeYPropertySetter::SharedPointer LayoutSizeYPropertySetter::Create()
{
   return LayoutSizeYPropertySetter::SharedPointer(CANDERA_NEW(LayoutSizeYPropertySetter));
}


}
}


}
