/* ***************************************************************************************
* FILE:          HMIRenderViewVisitor.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HMIRenderViewVisitor.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(HMIViewVisitor_h)
#define HMIViewVisitor_h

#include <Courier/Visualization/ViewVisitor.h>
#include <vector>
#include "Courier/Visualization/ViewId.h"
#include <CanderaPlatform/Device/Common/Base/DevicePackageDescriptor.h>

#include "hmibase/util/Macros.h"

namespace Courier {
class ViewScene;
}


namespace Candera {
class Surface;
}


namespace hmibase {
namespace view {

class HMIRenderViewVisitor : public Courier::ViewVisitor
{
   public:

      struct ViewInfo
      {
         std::string viewName;
         std::vector<unsigned int> surfaceIds;
         bool update;
         Candera::DevicePackageDescriptor::UnitCategory rtUnitType;
         unsigned int viewState;
      };
      typedef std::vector<ViewInfo> tViewInfoVector;

      HMIRenderViewVisitor() : isNewView(false)
      {
      }

      virtual ~HMIRenderViewVisitor()
      {
         m_vecActiveViews.clear();
         m_vecLastRenderedViews.clear();
      }

      virtual bool OnBegin()
      {
         isNewView = false;
         return true;
      }

      virtual bool Visit(Courier::ViewContainer* /*viewContainer*/)
      {
         return true;
      }

#if defined(CANDERA_2D_ENABLED)
      virtual void Visit(Courier::ViewScene2D* view);
#endif

#if defined(CANDERA_3D_ENABLED)
      virtual void Visit(Courier::ViewScene3D* view);
#endif

      virtual void OnEnd();

      inline const tViewInfoVector& getActiveViewInfo() const
      {
         return m_vecLastRenderedViews;
      }

      static bool getSurfaceId(const Candera::Surface* surface, unsigned int& surfaceId);
      static Candera::DevicePackageDescriptor::UnitCategory getRTUnitCategoryType(Candera::RenderTarget* rt);

   private:

      void updateActiveViewsContainer(Courier::ViewScene* view);

      tViewInfoVector m_vecLastRenderedViews;
      tViewInfoVector m_vecActiveViews;

      bool isNewView;
};


}
}


//! [RenderVisitor]

HMIBASE_DEPRECATED_TYPE_ALIAS(HMIRenderViewVisitor, ::hmibase::view::HMIRenderViewVisitor);

#endif
