/* ***************************************************************************************
* FILE:          DataCompletionHandler.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DataCompletionHandler.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "View/CGI/CgiExtensions/DataCompletionHandler.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/DataCompletionHandler.cpp.trc.h"
#endif

namespace hmibase {
   namespace view {

      DataCompletionHandler::DataCompletionHandler() : _listener(0), _timer(0)
      {
      }


      DataCompletionHandler::~DataCompletionHandler()
      {
         timerDestroy();
         _listener = 0;
         _timer = 0;
      }


      void DataCompletionHandler::timerDestroy()
      {
         if (0 != _timer)
         {
            _timer->stop();
            CANDERA_DELETE(_timer);
            _timer = NULL;
         }
      }


      void DataCompletionHandler::notifyDataComplete(TransitionHint hint)
      {
         // ... calls OnDataComplete on all listeners, first implementation only one listener
         if (0 != _listener)
         {
            if (hint != 0 && _timer != NULL)
            {
               ETG_TRACE_USR1_THR(("DataCompletionHandler::notifyDataComplete after %d msec", _timer->getElapsedTimeSinceStart()));
            }
            hint = 2;   // TODO
            _listener->onDataComplete(hint);
         }
         timerDestroy();
      }


      bool DataCompletionHandler::checkTimeout(::Util::Timer* const& ti)
      {
         if ((_timer != NULL) && (ti == _timer))
         {
            ETG_TRACE_USR1_THR(("DataCompletionHandler::checkTimeout !! Timeout after %d msec", _timer->getElapsedTimeSinceStart()));
            notifyDataComplete(0);
            return true;
         }
         return false;
      }


      bool DataCompletionHandler::setDataCompletionListener(IDataCompletionListener* listener, bool add, FeatStd::UInt32 timeout)
      {
         if (add)
         {
            _listener = listener;
            if (_timer == NULL)
            {
               _timer = CANDERA_NEW(Util::Timer)(timeout);
               if (_timer != NULL)
               {
                  _timer->setName("SceneTransitionMediator", "0");
               }
            }
            if (_timer != NULL)
            {
               _timer->stop();
               _timer->setTimeout(0, timeout);
               _timer->start();
            }
         }
         else
         {
            timerDestroy();
            _listener = 0;
         }
         return true;
      }
   }
}