/* ***************************************************************************************
* FILE:          CourierMsgQueue2ASF.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CourierMsgQueue2ASF.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_CourierMsgQueue2ASF_H_)
#define _CourierMsgQueue2ASF_H_

#include "Courier/Messaging/MessageReceiverPreprocessor.h"

namespace hmibase {
namespace view {

class CourierMsgQueue2ASF : public Courier::MessageReceiverPreprocessor
{
   private:
      typedef Courier::Internal::SingleLinkedList<Courier::MessageReferrer> tMsgRefList;
      Courier::Platform::CriticalSection  _critical;
      tMsgRefList                         _msgList;
   public:
      CourierMsgQueue2ASF();
      virtual ~CourierMsgQueue2ASF();
      bool Process();
      FeatStd::SizeType getSize();
      bool isEmpty();
      void addToQueue(const Courier::Message& message);
      bool fetch(Courier::MessageReferrer& msgRef);
};


}
}


extern ::hmibase::view::CourierMsgQueue2ASF _ASFCourierMsgQueue;
#endif
