/* ***************************************************************************************
* FILE:          CourierMsgQueue2ASF.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CourierMsgQueue2ASF.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "CourierMsgQueue2ASF.h"

namespace hmibase {
   namespace view {

      CourierMsgQueue2ASF::CourierMsgQueue2ASF()
      {
      }


      CourierMsgQueue2ASF::~CourierMsgQueue2ASF()
      {
      }


      bool CourierMsgQueue2ASF::Process()
      {
         return true;
      }


      FeatStd::SizeType CourierMsgQueue2ASF::getSize()
      {
         FeatStd::Internal::CriticalSectionLocker csLock(&_critical);
         return _msgList.GetSize();
      }


      bool CourierMsgQueue2ASF::isEmpty()
      {
         FeatStd::Internal::CriticalSectionLocker csLock(&_critical);
         return _msgList.IsEmpty();
      }


      void CourierMsgQueue2ASF::addToQueue(const Courier::Message& message)
      {
         FeatStd::Internal::CriticalSectionLocker csLock(&_critical);
         Courier::Message* pp = const_cast<Courier::Message*>(&message);
         Courier::MessageReferrer msgRef(pp);
         _msgList.Append(msgRef);
      }


      bool CourierMsgQueue2ASF::fetch(Courier::MessageReferrer& msgRef)
      {
         FeatStd::Internal::CriticalSectionLocker csLock(&_critical);

         if (!_msgList.IsEmpty())
         {
            tMsgRefList::Iterator firstMsgRef = _msgList.Begin();
            msgRef = *firstMsgRef;
            _msgList.Remove(*firstMsgRef);
            return true;
         }
         return false;
      }
   }
}