/* ***************************************************************************************
* FILE:          CourierMessageReceiverThread.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CourierMessageReceiverThread.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(CourierMessageReceiverThread_h)
#define CourierMessageReceiverThread_h

#include <Courier/Platform/Thread.h>
#include <Courier/Messaging/ComponentMessageReceiver.h>
#include <Courier/Diagnostics/Log.h>

namespace hmibase {
   namespace view {
      // ------------------------------------------------------------------------
      //! [CourierMessageReceiverThread]

      class CourierMessageReceiverThread : public Courier::Platform::Thread
      {
         COURIER_LOG_SET_REALM(FeatStd::Diagnostics::LogRealm::User);

      public:
         CourierMessageReceiverThread()
         {
         }

         // Make receiver active to start receiving messages
         void Activate()
         {
            mMsgReceiver.Activate();
         }

         void Attach(Courier::Component& component)
         {
            mMsgReceiver.Attach(&component);
         }

         void Detach(Courier::Component& component)
         {
            mMsgReceiver.Detach(&component);
         }

      protected:
         virtual Courier::Int ThreadFn()
         {
            mMsgReceiver.SetName(this->GetName());

            // fr83hi: standard wakeup configured  -> UseWakeUpRenderMechanism(true), so we do not need the next line
            //mMsgReceiver.SetCycleTime(Courier::ComponentMessageReceiverTiming::Cycle, 50); // 8

            bool lSuccess;
            // The message processing loop
            do
            {
               lSuccess = mMsgReceiver.Process();
            } while (lSuccess && !mMsgReceiver.IsShutdownTriggered());

            Courier::Int lRc;
            if (!lSuccess)
            {
               COURIER_LOG_FATAL("Thread (%s) processing failed!", GetName());
               lRc = -1;
            }
            else
            {
               COURIER_LOG_INFO("Thread (%s) processing ended normal.", GetName());
               lRc = 0;
            }

            return lRc;
         }

      private:
         Courier::ComponentMessageReceiver mMsgReceiver;
      };


      //! [CourierMessageReceiverThread]
   }
}
#endif
